/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

public interface WidgetArea {
    public boolean isMouseInArea(float var1, float var2, double var3, double var5);

    public static final class Sector
    implements WidgetArea {
        private final float radius;
        private final double clockwise;
        private final double flare;

        public Sector(float radius, double clockwise, double flare) {
            this.radius = radius;
            this.clockwise = Math.tan(clockwise);
            this.flare = Math.tan(flare);
        }

        @Override
        public boolean isMouseInArea(float x, float y, double mouseX, double mouseY) {
            boolean inRadius;
            boolean bl = inRadius = Math.sqrt((mouseX - (double)x) * (mouseX - (double)x) + (mouseY - (double)y) * (mouseY - (double)y)) <= (double)this.radius;
            if (inRadius) {
                double angle = (mouseX - (double)x) / ((double)y - mouseY);
                return angle >= this.clockwise && angle <= this.clockwise + this.flare;
            }
            return false;
        }

        public float getRadius() {
            return this.radius;
        }
    }

    public static final class Circle
    implements WidgetArea {
        private final float radius;

        public Circle(float radius) {
            this.radius = radius;
        }

        @Override
        public boolean isMouseInArea(float x, float y, double mouseX, double mouseY) {
            return Math.sqrt((mouseX - (double)x) * (mouseX - (double)x) + (mouseY - (double)y) * (mouseY - (double)y)) <= (double)this.radius;
        }

        public float getRadius() {
            return this.radius;
        }
    }
}

